from datetime import datetime
import subprocess
import os
import sys

build_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")

wr_cfg = f'BUILD_TIME = "{build_time}"\n'

with open("build_info.py", "w", encoding="utf-8") as f:
    f.write(
        f"# 此文件由构建脚本自动生成，请勿手动修改\n{wr_cfg}"
    )

os.environ["HTTP_PROXY"] = "http://127.0.0.1:7890"
os.environ["HTTPS_PROXY"] = "http://127.0.0.1:7890"


cmd = [
    sys.executable,
    "-m", "nuitka",
    "--standalone",
    "--show-memory",
    "--show-progress",
    "--include-data-file=icon.ico=icon.ico",
    "--windows-disable-console",    
    "--assume-yes-for-downloads",
    "--windows-icon-from-ico=icon.ico",
    "--output-dir=dist",
    "--enable-plugin=tk-inter",
    "folder_sync.py",
]

subprocess.run(cmd, check=True)



